FUNCTION_BLOCK PMC_ArcMotionCenter
	CASE CmdSta OF
		0:  (* IDLING*)
			(*check if the rising edge of execute*)
			IF (PreExecute = FALSE) AND (Execute = TRUE) THEN
				(*command being triggered*)
				(*Sending Command to PMC*)
				(* read current heart beat of field bus*)
				memcpy(pDest := ADR(cmdHB),pSrc := ADR(FBin_pointer) + P2H_START + P2H_CMDC_OFFSET,length := 1);
				(*update command heart beat*)
				cmdHB := cmdHB + 1;
				cmdHB := cmdHB AND 255;
				(*--------------write command info*)
				(*command ID*)
				memcpy(pDest := ADR(FBout_pointer) + H2P_START + H2P_CMDID_OFFSET,pSrc := ADR(cmdID),length := 2);
				(*command label*)
				memcpy(pDest := ADR(FBout_pointer) + H2P_START + H2P_CMDLB_OFFSET,pSrc := ADR(cmdLB),length := 2);
				(*XBOT ID:*)
				memcpy(pDest := ADR(FBout_pointer) + H2P_START + H2P_DATA_OFFSET + 4,pSrc := ADR(XbotID),length := 1);
				(*Arc motion mode: *)
				memcpy(pDest := ADR(FBout_pointer) + H2P_START + H2P_DATA_OFFSET + 3,pSrc := ADR(Mode),length := 1);
				(*Arc Definition: *)
				memcpy(pDest := ADR(FBout_pointer) + H2P_START + H2P_DATA_OFFSET + 5,pSrc := ADR(aDef),length := 1);
				(*Rotation direction: *)
				memcpy(pDest := ADR(FBout_pointer) + H2P_START + H2P_DATA_OFFSET + 6,pSrc := ADR(Dir),length := 1);
				(*PosX*)
				memcpy(pDest := ADR(FBout_pointer) + H2P_START + H2P_DATA_OFFSET + 19,pSrc := ADR(CenterX),length := 4);
				(*PosY*)
				memcpy(pDest := ADR(FBout_pointer) + H2P_START + H2P_DATA_OFFSET + 23,pSrc := ADR(CenterY),length := 4);
				(*Radius*)
				memcpy(pDest := ADR(FBout_pointer) + H2P_START + H2P_DATA_OFFSET + 27,pSrc := ADR(Angle),length := 4);
				(*End Speed*)
				memcpy(pDest := ADR(FBout_pointer) + H2P_START + H2P_DATA_OFFSET + 7,pSrc := ADR(EndVel),length := 4);
				(*Max. Speed*)
				memcpy(pDest := ADR(FBout_pointer) + H2P_START + H2P_DATA_OFFSET + 11,pSrc := ADR(MaxVel),length := 4);
				(*Max. Acceleration*)
				memcpy(pDest := ADR(FBout_pointer) + H2P_START + H2P_DATA_OFFSET + 15,pSrc := ADR(MaxAcc),length := 4);
				(*write command heart beat*)
				memcpy(pDest := ADR(FBout_pointer) + H2P_START + H2P_CMDC_OFFSET,pSrc := ADR(cmdHB),length := 1);
				(*reset output*)
				Error := FALSE;
				ErrorID := 0;
				Done := FALSE;
				Busy := TRUE;
				Aborted := FALSE;
				timeout := 0;
				(*change state to BUSY*)
				CmdSta := 1;
			END_IF;
		1:  (* Waiting for Command return*)
			memcpy(pDest := ADR(cmdHBRtn),pSrc := ADR(FBin_pointer) + P2H_START + P2H_CMDC_OFFSET,length := 1);
			cmdHBRtn := cmdHBRtn AND 255;
			dd := cmdHBRtn - cmdHB;
			IF dd <> 0 THEN
				(*no reply from PMC*)
				timeout := timeout + 1;
				IF timeout > PMC_TIMEOUT THEN
					(* Statement section IF*)
					Error := TRUE;
					ErrorID := 8201;
					CmdSta := 0;
				END_IF;
			ELSE
				(*PMC reply*)
				memcpy(pDest := ADR(cmdIDRtn),pSrc := ADR(FBin_pointer) + P2H_START + P2H_CMDID_OFFSET,length := 2);
				IF cmdIDRtn <> cmdID THEN
					(* Statement section IF*)
					Aborted := TRUE;
				ELSE
					Done := TRUE;
				END_IF;
				memcpy(pDest := ADR(ErrorID),pSrc := ADR(FBin_pointer) + P2H_START + P2H_RTN_OFFSET,length := 2);
				IF ErrorID <> 0 THEN
					(* Statement section IF*)
					Error := TRUE;
				ELSE
					(*travel time.*)
					memcpy(pDest := ADR(TravelTime),pSrc := ADR(FBin_pointer) + P2H_START + P2H_DATA_OFFSET + 5,length := 4);
				END_IF;
				Busy := FALSE;
				(*change state to IDLE*)
				CmdSta := 0;
			END_IF;
	END_CASE;
	
	(*save execute singnal to local*)
	PreExecute := Execute;

END_FUNCTION_BLOCK
